<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.7
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Mirasvit\PromoBanner\Api\Data\BannerInterface;

class Banner extends AbstractModel implements BannerInterface
{
    private $ruleFactory;

    private $rule;

    public function __construct(
        Banner\RuleFactory $ruleFactory,
        Context $context,
        \Magento\Framework\Registry $registry
    ) {
        $this->ruleFactory = $ruleFactory;

        parent::__construct($context, $registry);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\Banner::class);
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->getData(self::ID);
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->getData(self::NAME);
    }

    /**
     * {@inheritdoc}
     */
    public function setName($value)
    {
        return $this->setData(self::NAME, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function isActive()
    {
        return $this->getData(self::IS_ACTIVE);
    }

    /**
     * {@inheritdoc}
     */
    public function setIsActive($value)
    {
        return $this->setData(self::IS_ACTIVE, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function getActiveFrom()
    {
        return $this->getData(self::ACTIVE_FROM);
    }

    /**
     * {@inheritdoc}
     */
    public function setActiveFrom($value)
    {
        return $this->setData(self::ACTIVE_FROM, $value ? $value : null);
    }

    /**
     * {@inheritdoc}
     */
    public function getActiveTo()
    {
        return $this->getData(self::ACTIVE_TO);
    }

    /**
     * {@inheritdoc}
     */
    public function setActiveTo($value)
    {
        return $this->setData(self::ACTIVE_TO, $value ? $value : null);
    }

    /**
     * {@inheritdoc}
     */
    public function getPositions()
    {
        return explode(',', $this->getData(self::POSITIONS));
    }

    /**
     * {@inheritdoc}
     */
    public function setPositions(array $value)
    {
        return $this->setData(self::POSITIONS, implode(',', $value));
    }

    /**
     * {@inheritdoc}
     */
    public function getSortOrder()
    {
        return $this->getData(self::SORT_ORDER);
    }

    /**
     * {@inheritdoc}
     */
    public function setSortOrder($value)
    {
        return $this->setData(self::SORT_ORDER, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        return $this->getData(self::CONTENT);
    }

    /**
     * {@inheritdoc}
     */
    public function setContent($value)
    {
        return $this->setData(self::CONTENT, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function getConditions()
    {
        return $this->getData(self::CONDITIONS_SERIALIZED);
    }

    /**
     * {@inheritdoc}
     */
    public function setConditions($value)
    {
        return $this->setData(self::CONDITIONS_SERIALIZED, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerGroupIds()
    {
        return explode(',', $this->getData(self::CUSTOMER_GROUP_IDS));
    }

    /**
     * {@inheritdoc}
     */
    public function setCustomerGroupIds(array $value)
    {
        return $this->setData(self::CUSTOMER_GROUP_IDS, implode(',', $value));
    }

    /**
     * {@inheritdoc}
     */
    public function getStoreIds()
    {
        return explode(',', $this->getData(self::STORE_IDS));
    }

    /**
     * {@inheritdoc}
     */
    public function setStoreIds(array $value)
    {
        return $this->setData(self::STORE_IDS, implode(',', $value));
    }

    /**
     * @return Banner\Rule
     */
    public function getRule()
    {
        if (!$this->rule) {
            $this->rule = $this->ruleFactory->create()
                ->setData(self::CONDITIONS_SERIALIZED, $this->getData(self::CONDITIONS_SERIALIZED));
        }

        return $this->rule;
    }
}