<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.11
 * @copyright Copyright (C) 2020 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Block;

use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Loader extends Template
{
    /**
     * @var Registry
     */
    private $registry;

    /**
     * Loader constructor.
     * @param Context $context
     * @param Registry $registry
     */
    public function __construct(
        Context $context,
        Registry $registry
    ) {
        $this->registry = $registry;
        parent::__construct($context);
    }

    /**
     * @return array
     */
    public function getJsConfig()
    {
        /** @var \Magento\Framework\App\Request\Http $request */
        $request = $this->_request;

        return [
            '*' => [
                'Mirasvit_PromoBanner/js/loader' => [
                    'url'    => $this->getUrl('promo_banner/banner/loader'),
                    'params' => [
                        'page_type'  => $request->getFullActionName(),
                        'product_id' => $this->registry->registry('current_product') ?
                            $this->registry->registry('current_product')->getId() : null,
                        'uri' => $request->getUriString()
                    ],
                ],
            ],
        ];
    }

}
