<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.0.26
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Api\Service\Performer;

interface PerformerInterface
{
    /**
     * @param \Magento\User\Model\User|\Magento\Customer\Model\Customer $object
     * @return void
     */
    public function setPerfomer($object);

    /**
     * @return int
     */
    public function getId();

    /**
     * @return string
     */
    public function getName();

    /**
     * @param \Mirasvit\Rma\Api\Data\RmaInterface $rma
     * @return void
     */
    public function setRmaAttributesBeforeSave($rma);

    /**
     * @param \Mirasvit\Rma\Api\Data\MessageInterface $message
     * @param array                                   $params
     * @return void
     */
    public function setMessageAttributesBeforeAdd($message, $params = []);
}