<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.0.1
 * @copyright Copyright (C) 2017 Mirasvit (https://mirasvit.com/)
 */


namespace Mirasvit\Rma\Model\UI\Rma;

class RmaGridDataProvider extends \Magento\Framework\View\Element\UiComponent\DataProvider\DataProvider
{
    /**
     * {@inheritdoc}
     */
    public function addFilter(\Magento\Framework\Api\Filter $filter)
    {
        if ($filter->getField() == 'status_id') {
            $filter->setField('main_table.status_id');
        }
        if ($filter->getField() == 'created_at') {
            $filter->setField('main_table.created_at');
        }
        if ($filter->getField() == 'updated_at') {
            $filter->setField('main_table.updated_at');
        }
        if ($filter->getField() == 'customer_name') {
            $filter->setField('main_table.name');
        }
        if ($filter->getField() == 'increment_id') {
            $filter->setField('main_table.increment_id');
        }
        if ($filter->getField() == 'order_id') {
            $filter->setField('order.increment_id');
        }

        parent::addFilter($filter);
    }

    /**
     * {@inheritdoc}
     */
    public function addOrder($field, $direction)
    {
        if ($field == 'customer_name') {
            $field = 'name';
        }

        parent::addOrder($field, $direction);
    }

    /**
     * Returns Search result
     *
     * @return \Mirasvit\Rma\Model\ResourceModel\Rma\Collection
     */
    public function getSearchResult()
    {
        $groups     = [];
        $fieldValue = '';
        /** @var \Magento\Framework\Api\Search\FilterGroup $group */
        foreach ($this->getSearchCriteria()->getFilterGroups() as $group) {
            if (empty($group->getFilters())) {
                continue;
            }
            $isAdded = false;
            $filters = [];
            /** @var \Magento\Framework\Api\Filter $filter */
            foreach ($group->getFilters() as $filter) {
                if ($filter->getField() == 'main_table.name' && !$isAdded) {
                    $fieldValue = $filter->getValue();
                    continue;
                }
                $filters[] = $filter;
            }
            $group->setFilters($filters);
            $groups[] = $group;
        }
        $this->getSearchCriteria()->setFilterGroups($groups);
        $collection = $this->reporting->search($this->getSearchCriteria());
        if ($fieldValue) {
            $collection->getSelect()->where(
                'CONCAT(main_table.firstname, main_table.lastname) like ?',
                '%' . $fieldValue . '%'
            );
        }
        return $collection;
    }
}
