<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.5
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Setup\Patch\Data;

use Magento\Authorization\Model\Acl\AclRetriever;
use Magento\Authorization\Model\ResourceModel\Role\CollectionFactory;
use Magento\Authorization\Model\RulesFactory;
use Magento\Framework\Authorization\PolicyInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;

class DataPatch1017 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;

    private $roleCollectionFactory;

    private $rulesFactory;

    private $policyInterface;

    private $aclRetriever;

    public function __construct(
        ModuleDataSetupInterface $setup,
        CollectionFactory        $roleCollectionFactory,
        RulesFactory             $rulesFactory,
        PolicyInterface          $policyInterface,
        AclRetriever             $aclRetriever
    ) {
        $this->setup                 = $setup;
        $this->roleCollectionFactory = $roleCollectionFactory;
        $this->rulesFactory          = $rulesFactory;
        $this->policyInterface       = $policyInterface;
        $this->aclRetriever          = $aclRetriever;
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies(): array
    {
        return [
            DataPatch1016::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.17';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->setup->startSetup();

        $rmaResources = ['Mirasvit_Rma::actions', 'Mirasvit_Rma::add', 'Mirasvit_Rma::delete'];
        $roles        = $this->roleCollectionFactory->create();
        $roles->addFieldToFilter('role_type', 'G');

        foreach ($roles as $role) {
            $allowedResources     = $this->aclRetriever->getAllowedResourcesByRole($role->getId());
            $isAccessToRmaAllowed = $this->policyInterface->isAllowed($role->getId(), 'Mirasvit_Rma::rma');

            if ($isAccessToRmaAllowed && $allowedResources != ['Magento_Backend::all']) {
                foreach ($rmaResources as $rmaResource) {
                    $allowedResources[] = $rmaResource;
                }

                $this->rulesFactory->create()->setRoleId($role->getId())
                    ->setResources($allowedResources)
                    ->saveRel();
            }
        }

        $this->setup->endSetup();
    }
}
