<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.5
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Model\UI\Rma\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Sales\Api\CreditmemoRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Mirasvit\Rma\Model\RmaFactory;
use Magento\Framework\Escaper;
use Magento\Backend\Helper\Data as DataHelper;

class CreditmemoColumn extends Column
{
    private $rmaFactory;

    private $helper;

    private $escaper;

    protected $creditmemoRepository;

    protected $searchCriteriaBuilder;

    public function __construct(
        RmaFactory $rmaFactory,
        Escaper $escaper,
        DataHelper $helper,
        CreditmemoRepositoryInterface $creditmemoRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->rmaFactory            = $rmaFactory;
        $this->escaper               = $escaper;
        $this->helper                = $helper;
        $this->creditmemoRepository  = $creditmemoRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $name = $this->getData('name');
                $creditMemoIncrementIds = [];

                if ($name == 'credit_memo_ids' || $item[$name]) {
                    $rma = $this->rmaFactory->create();
                    $rma->getResource()->load($rma, $item[$rma->getIdFieldName()]);
                    $rma->getResource()->afterLoad($rma);

                    if ($rma->getCreditMemoIds()){
                      $searchCriteria = $this->searchCriteriaBuilder
                          ->addFilter(
                              'entity_id',
                              $rma->getCreditMemoIds(),
                              'in'
                          )->create();

                      $creditMemos = $this->creditmemoRepository
                          ->getList($searchCriteria)
                          ->getItems();

                      foreach ($creditMemos as $creditMemo) {
                        $creditMemoIncrementIds[] = $creditMemo->getIncrementId();
                      }
                    }

                    $str = '';

                    if ($rma->getData($name)) {
                        $str .= implode(', ', $creditMemoIncrementIds);
                    }

                    $item[$name] = $str;
                } else {
                    $item[$name] = '';
                }
            }
        }

        return $dataSource;
    }
}
