<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.2
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Rma\Api\Data\ResolutionInterface;
use Mirasvit\Rma\Api\Data\RmaInterface;
use Mirasvit\Rma\Api\Data\StatusInterface;

class DataPatch1015 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;

    public function __construct(
        ModuleDataSetupInterface $setup
    ) {
        $this->setup = $setup;
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies(): array
    {
        return [
            DataPatch1011::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.15';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->setup->startSetup();

        $table = $this->setup->getTable('mst_rma_rma');
        $select = $this->setup->getConnection()->select()
            ->from(
                ['main_table' => $table],
                [
                    RmaInterface::KEY_STATUS_HISTORY => RmaInterface::KEY_STATUS_ID,
                ]
            );

        $select = $this->setup->getConnection()->updateFromSelect(
            $select,
            $table
        );

        $this->setup->getConnection()->query($select);

        $table = $this->setup->getTable('mst_rma_status');
        $this->setup->getConnection()->update(
            $table,
            [StatusInterface::KEY_COLOR => 'yellow'],
            [StatusInterface::KEY_CODE . ' = ?' => 'pending']
        );
        $this->setup->getConnection()->update(
            $table,
            [StatusInterface::KEY_COLOR => 'green'],
            [StatusInterface::KEY_CODE . ' = ?' => 'approved']
        );
        $this->setup->getConnection()->update(
            $table,
            [StatusInterface::KEY_COLOR => 'orange'],
            [StatusInterface::KEY_CODE . ' = ?' => 'rejected']
        );
        $this->setup->getConnection()->update(
            $table,
            [StatusInterface::KEY_COLOR => 'teal'],
            [StatusInterface::KEY_CODE . ' = ?' => 'package_sent']
        );

        $this->setup->endSetup();
    }
}
