<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.1.29
 * @copyright Copyright (C) 2021 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Setup\UpgradeSchema;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

class UpgradeSchema1019 implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function upgrade(SchemaSetupInterface $installer, ModuleContextInterface $context)
    {
        $installer->getConnection()
            ->addIndex(
                $installer->getTable('mst_rma_attachment'),
                $installer->getIdxName('mst_rma_attachment', ['item_id']),
                ['item_id'],
                \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_INDEX
            );
        $installer->getConnection()->addForeignKey(
            $installer->getFkName(
                'mst_rma_attachment',
                'item_id',
                'mst_rma_message',
                'message_id'
            ),
            $installer->getTable('mst_rma_attachment'),
            'item_id',
            $installer->getTable('mst_rma_message'),
            'message_id',
            \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
        );
    }
}
