<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.0.61
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Reports\Config\Type;

use Mirasvit\ReportApi\Api\Config\AggregatorInterface;
use Mirasvit\ReportApi\Api\Config\TypeInterface;
use Mirasvit\ReportApi\Config\Type\Str;

class ReasonStoreName extends Str implements TypeInterface
{
    private $reasonRepository;

    public function __construct(
        \Mirasvit\Rma\Api\Repository\ReasonRepositoryInterface $reasonRepository
    ) {
        $this->reasonRepository = $reasonRepository;
    }

    public function getType()
    {
        return 'Mirasvit.reason_store_name';
    }

    public function getAggregators()
    {
        return ['none', 'avg'];
    }

    public function getJsType()
    {
        return self::JS_TYPE_NUMBER;
    }

    public function getFormattedValue($actualValue, AggregatorInterface $aggregator)
    {
        if ($actualValue === null) {
            return self::NA;
        }

        $reason = $this->reasonRepository->get($actualValue);

        return $reason->getName();
    }
}
