<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.1.32
 * @copyright Copyright (C) 2021 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Controller;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Exception\NotFoundException;
use Mirasvit\Rma\Service\Config\FrontendConfig;
use Mirasvit\Rma\Helper\Controller\Rma\StrategyFactory;
use Magento\Customer\Model\Session;

abstract class Rma extends Action
{
    protected $openActions
        = [
            'external',
            'postexternal',
            'print',
        ];

    protected $strategy;

    private   $strategyFactory;

    private   $context;

    protected $customerSession;

    protected $frontendConfig;

    public function __construct(
        StrategyFactory $strategyFactory,
        Session         $customerSession,
        FrontendConfig  $frontendConfig,
        Context         $context
    ) {
        $this->strategyFactory = $strategyFactory;
        $this->customerSession = $customerSession;
        $this->frontendConfig  = $frontendConfig;
        $this->context         = $context;
        $this->resultFactory   = $context->getResultFactory();

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    public abstract function isRequireCustomerAutorization();

    /**
     * {@inheritdoc}
     */
    public function dispatch(\Magento\Framework\App\RequestInterface $request)
    {
        if (!$this->frontendConfig->isFrontendActive()) {
            throw new NotFoundException(__('Page not found.'));
        }

        $this->strategy = $this->strategyFactory->create($request);

        if (!$this->getRequest()->isDispatched()) {
            parent::dispatch($request);
        }

        if (!$this->isRequireCustomerAutorization()) {
            return parent::dispatch($request);
        }

        $action  = strtolower($this->getRequest()->getActionName());
        $pattern = '/^(' . implode('|', $this->openActions) . ')$/i';

        if (!preg_match($pattern, $action)) {
            if (!$this->customerSession->authenticate()) {
                $this->_actionFlag->set('', 'no-dispatch', true);
            }
        } else {
            $this->customerSession->setNoReferer(true);
        }

        $result = parent::dispatch($request);
        $this->customerSession->unsNoReferer(false);

        return $result;
    }

    /**
     * @param \Magento\Framework\Controller\ResultInterface $resultPage
     *
     * @return void
     */
    protected function initPage(\Magento\Framework\Controller\ResultInterface $resultPage)
    {
        if (!$this->strategy->isRequireCustomerAutorization()) {
            $layout = $resultPage->getLayout();
            $layout->unsetElement('div.sidebar.additional');
            $layout->unsetElement('sidebar.main');
            $pageConfig = $resultPage->getConfig();
            $pageConfig->setPageLayout('1column');
        }

        if ($navigationBlock = $resultPage->getLayout()->getBlock('customer_account_navigation')) {
            $navigationBlock->setActive('rma');
        }
    }
}
