define([
    'rjsResolver'
], function (resolver) {
    'use strict';
    /** copied from vendor/magento/module-checkout/view/frontend/web/js/checkout-loader.js to prevent errors when other extensions overwrite "checkout-loader" */
    
    /**
     * Removes provided loader element from DOM.
     *
     * @param {HTMLElement} $loader - Loader DOM element.
     */
    function hideLoader($loader) {
        $loader.parentNode.removeChild($loader);
    }
    
    /**
     * Initializes assets loading process listener.
     *
     * @param {Object} config - Optional configuration
     * @param {HTMLElement} $loader - Loader DOM element.
     */
    function init(config, $loader) {
        resolver(hideLoader.bind(null, $loader));
    }
    
    return init;
});
