<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.21
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Rma\Api\Data\ResolutionInterface;

class DataPatch1011 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;

    public function __construct(
        ModuleDataSetupInterface $setup
    ) {
        $this->setup = $setup;
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies(): array
    {
        return [
            DataPatch105::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.11';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->setup->startSetup();

        $table = $this->setup->getTable('mst_rma_resolution');
        $bind  = [
            ResolutionInterface::KEY_CREDITMEMO_ALLOWED        => 0,
            ResolutionInterface::KEY_EXCHANGE_ORDER_ALLOWED    => 1,
            ResolutionInterface::KEY_REPLACEMENT_ORDER_ALLOWED => 1,
        ];
        $where = [ResolutionInterface::KEY_CODE . ' = ?' => ResolutionInterface::EXCHANGE];
        $this->setup->getConnection()->update($table, $bind, $where);

        $table = $this->setup->getTable('mst_rma_resolution');
        $bind  = [
            ResolutionInterface::KEY_CREDITMEMO_ALLOWED        => 0,
            ResolutionInterface::KEY_EXCHANGE_ORDER_ALLOWED    => 1,
            ResolutionInterface::KEY_REPLACEMENT_ORDER_ALLOWED => 1,
        ];
        $where = [ResolutionInterface::KEY_CODE . ' = ?' => ResolutionInterface::REFUND];
        $this->setup->getConnection()->update($table, $bind, $where);

        $table = $this->setup->getTable('mst_rma_resolution');
        $bind  = [
            ResolutionInterface::KEY_CREDITMEMO_ALLOWED        => 1,
            ResolutionInterface::KEY_EXCHANGE_ORDER_ALLOWED    => 0,
            ResolutionInterface::KEY_REPLACEMENT_ORDER_ALLOWED => 0,
        ];
        $where = [ResolutionInterface::KEY_CODE . ' = ?' => ResolutionInterface::CREDIT];
        $this->setup->getConnection()->update($table, $bind, $where);

        $this->setup->endSetup();
    }
}
