<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.21
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Controller\Rma;

use Magento\Framework\Controller\ResultFactory;
use Magento\Sales\Model\OrderFactory;
use Magento\Framework\Registry;
use Mirasvit\Rma\Helper\Controller\Rma\StrategyFactory;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Mirasvit\Rma\Service\Config\FrontendConfig;

class Order extends \Mirasvit\Rma\Controller\Rma
{
    private   $registry;

    private   $orderFactory;

    protected $frontendConfig;

    public function __construct(
        OrderFactory    $orderFactory,
        Registry        $registry,
        StrategyFactory $strategyFactory,
        Session         $customerSession,
        FrontendConfig  $frontendConfig,
        Context         $context
    ) {
        $this->orderFactory   = $orderFactory;
        $this->frontendConfig = $frontendConfig;
        $this->registry       = $registry;

        parent::__construct($strategyFactory, $customerSession, $frontendConfig, $context);
    }

    /**
     * Shows list of RMAs in the order view page in customer account
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        if ($orderId = $this->getRequest()->getParam('order_id')) {
            $order = $this->orderFactory->create()->load($orderId);
            $customer = $this->strategy->getPerformer();
            if ($order->getCustomerId() == $customer->getId()) {
                $this->registry->register('current_order', $order);
                if ($navigationBlock = $resultPage->getLayout()->getBlock('customer_account_navigation')) {
                    $navigationBlock->setActive('sales/order/history');
                }
                return $resultPage;
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function isRequireCustomerAutorization()
    {
        return $this->strategy->isRequireCustomerAutorization();
    }
}
