<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.7
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Rma\Ui\QuickDataBar;

use Magento\Backend\Block\Template;
use Magento\Framework\App\ObjectManager;
use Mirasvit\Core\Ui\QuickDataBar\ScalarDataBlock;
use Mirasvit\Core\Ui\QuickDataBar\MultiScalarDataBlock;

class OverviewDataBlock extends MultiScalarDataBlock
{
    private $objectManager;

    public function __construct(
        \Magento\Framework\ObjectManagerInterface $objectManager,
        Template\Context $context
    ) {
        $this->objectManager = $objectManager;

        parent::__construct($context);
    }
    public function getCode(): string
    {
        return 'rma_unread';
    }

    public function getLabel(): string
    {
        return (string)__('Overview');
    }

    public function getChildDataBlocks(): array
    {
        return [
            ObjectManager::getInstance()->create(OverviewDataBlocks\UnreadDataBlock::class),
            ObjectManager::getInstance()->create(OverviewDataBlocks\RefundDataBlock::class),
        ];
    }

    public function getScalarValues(): array
    {
        $data = [];

        /** @var ScalarDataBlock $block */
        foreach ($this->getChildDataBlocks() as $block) {
            $data[] = [
                'label' => $block->getLabel(),
                'value' => $block->getScalarValue(),
            ];
        }

        return $data;
    }
}
