<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.0.61-beta
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */


namespace Mirasvit\Rma\Setup\UpgradeData;

use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Mirasvit\Rma\Api\Data\RmaInterface;

class UpgradeData1015 implements UpgradeDataInterface
{

    /**
     * {@inheritdoc}
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        $table = $setup->getTable('mst_rma_rma');
        $select = $setup->getConnection()->select()
            ->from(
                ['main_table' => $table],
                [
                    RmaInterface::KEY_STATUS_HISTORY => RmaInterface::KEY_STATUS_ID,
                ]
            );

        $select = $setup->getConnection()->updateFromSelect(
            $select,
            $table
        );

        $setup->getConnection()->query($select);
        $setup->endSetup();
    }
}