<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.0.61-beta
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Model\Config\Source\Status;

class Color implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @return array
     */
    public function toArray()
    {
        return [
            ''                      => __('Select color'),
            'status-branch-aqua'    => __('Aqua'),
            'status-branch-grey'    => __('Grey'),
            'status-branch-navy'    => __('Navy'),
            'status-branch-silver'  => __('Silver'),
            'status-branch-black'   => __('Black'),
            'status-branch-green'   => __('Green'),
            'status-branch-olive'   => __('Olive'),
            'status-branch-teal'    => __('Teal'),
            'status-branch-blue'    => __('Blue'),
            'status-branch-lime'    => __('Lime'),
            'status-branch-purple'  => __('Purple'),
            'status-branch-fuchsia' => __('Fuchsia'),
            'status-branch-maroon'  => __('Maroon'),
            'status-branch-red'     => __('Red'),
            'status-branch-orange'  => __('Orange'),
            'status-branch-yellow'  => __('Yellow'),
        ];
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $result = [];
        foreach ($this->toArray() as $k => $v) {
            $result[] = ['value' => $k, 'label' => $v];
        }

        return $result;
    }

    /************************/
}
