<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.8
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Setup\Patch\Data;

use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;

class DataPatch1016 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;

    private $productMetadata;

    private $config;

    public function __construct(
        ModuleDataSetupInterface $setup,
        ProductMetadataInterface $productMetadata,
        WriterInterface          $config
    ) {
        $this->setup           = $setup;
        $this->productMetadata = $productMetadata;
        $this->config          = $config;
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies(): array
    {
        return [
            DataPatch1015::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.16';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->setup->startSetup();

        if (version_compare($this->productMetadata->getVersion(), '2.3.3', '==')) {
            $data = [
                ['from' => 'Ỳ', 'to' => 'y'],
                ['from' => 'Ǹ', 'to' => 'n'],
                ['from' => 'Ẁ', 'to' => 'w'],
            ];
            foreach ($data as $k => $v) {
                $this->config->save('url/convert/' . $k . '/from', $v['from'], 'default');
                $this->config->save('url/convert/' . $k . '/to', $v['to'], 'default');
            }
        }

        $this->setup->endSetup();
    }
}
