<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.11
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Controller\Rma;

use Magento\Framework\Controller\ResultFactory;
use Mirasvit\Rma\Helper\Controller\Rma\GuestStrategy;
use Mirasvit\Rma\Api\Repository\RmaRepositoryInterface;
use Mirasvit\Rma\Api\Service\Rma\RmaManagement\SaveInterface;
use Magento\Framework\Registry;
use Mirasvit\Rma\Helper\Controller\Rma\StrategyFactory;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Mirasvit\Rma\Service\Config\FrontendConfig;

class View extends \Mirasvit\Rma\Controller\Rma
{
    private   $rmaSaveManagement;

    private   $registry;

    private   $rmaRepository;

    protected $frontendConfig;

    public function __construct(
        StrategyFactory        $strategyFactory,
        RmaRepositoryInterface $rmaRepository,
        SaveInterface          $rmaSaveManagement,
        Registry               $registry,
        Session                $customerSession,
        FrontendConfig         $frontendConfig,
        Context                $context
    ) {
        $this->rmaRepository     = $rmaRepository;
        $this->rmaSaveManagement = $rmaSaveManagement;
        $this->frontendConfig    = $frontendConfig;
        $this->registry          = $registry;

        parent::__construct($strategyFactory, $customerSession, $frontendConfig, $context);
    }


    /**
     * {@inheritdoc}
     */
    public function isRequireCustomerAutorization()
    {
        return $this->strategy->isRequireCustomerAutorization();
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        try {
            $rma = $this->strategy->initRma($this->getRequest());
            $this->registry->register('current_rma', $rma);
            $this->rmaSaveManagement->markAsReadForCustomer($rma);
            /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
            $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
            $this->initPage($resultPage);

            return $resultPage;
        } catch(\Magento\Framework\Exception\NoSuchEntityException $e) {
            /** @var \Magento\Framework\Controller\Result\Forward $resultForward */
            $resultForward = $this->resultFactory->create(ResultFactory::TYPE_FORWARD);
            return $resultForward->forward('noroute');
        }
    }
}
