<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.11
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Rma\Controller\Adminhtml\Rma;

use Mirasvit\Rma\Controller\Adminhtml\Rma;
use Mirasvit\Rma\Model\RmaFactory;
use Magento\Backend\App\Action\Context;

class ConvertTicket extends Rma
{
    private $rmaFactory;

    public function __construct(
        RmaFactory $rmaFactory,
        Context $context
    ) {
        $this->rmaFactory = $rmaFactory;

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        /** @var \Mirasvit\Rma\Api\Config\HelpdeskConfigInterface $helpdeskConfig */
        $helpdeskConfig = $objectManager->create('\Mirasvit\Rma\Api\Config\HelpdeskConfigInterface');

        if ($helpdeskConfig->isHelpdeskActive()) {
           /** @var \Mirasvit\Helpdesk\Model\Ticket $ticket */
           $ticket = $objectManager->create('Mirasvit\Helpdesk\Model\TicketFactory')->create();
           $ticket->getResource()->load($ticket, (int) $this->getRequest()->getParam('id'));

           $this->_redirect('*/*/add', ['orders_id' => $ticket->getOrderId(), 'ticket_id' => $ticket->getId()]);
        }
    }
}
