<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-rma
 * @version   2.2.26
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


namespace Mirasvit\Rma\Service\Config;

use Magento\Store\Model\ScopeInterface;
use Magento\Framework\Filesystem;
use Magento\Framework\App\Config\ScopeConfigInterface;

class RmaConfig implements \Mirasvit\Rma\Api\Config\RmaConfigInterface
{
    private $scopeConfig;

    protected $filesystem;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        Filesystem $filesystem
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->filesystem = $filesystem;
    }

    /**
     * {@inheritdoc}
     */
    public function getReturnAddress($store = null)
    {
        return $this->scopeConfig->getValue(
            'rma/general/return_address',
            ScopeInterface::SCOPE_STORE,
            $store
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultStatus($store = null)
    {
        return $this->scopeConfig->getValue(
            'rma/general/default_status',
            ScopeInterface::SCOPE_STORE,
            $store
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultUser($store = null)
    {
        return $this->scopeConfig->getValue(
            'rma/general/default_user',
            ScopeInterface::SCOPE_STORE,
            $store
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getGeneralBrandAttribute($store = null)
    {
        return $this->scopeConfig->getValue(
            'rma/general/brand_attribute',
            \Magento\Framework\App\Config\ScopeConfigInterface::SCOPE_TYPE_DEFAULT,
            $store
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getGeneralAttachmentStorage($store = null)
    {
        return $this->scopeConfig->getValue(
            'rma/general/attachment_storage',
            \Magento\Framework\App\Config\ScopeConfigInterface::SCOPE_TYPE_DEFAULT,
            $store
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getAttachmentFolderPath()
    {
        return $this->filesystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)
                ->getAbsolutePath() . 'rma/attachments/';
    }

    /**
     * @param string $uid
     *
     * @return string
     */
    public function getExternalPath($uid)
    {
        return $this->getAttachmentFolderPath() .
            substr($uid, 0, 1) . '/' . substr($uid, 1, 2) . '/' . $uid;
    }
}
