define([
    'underscore',
    'ko',
    'Magento_Ui/js/form/element/ui-select'
], function (_, ko, UiSelect) {
    'use strict';
    
    return UiSelect.extend({
        defaults: {
            template: 'ui/grid/filters/elements/ui-select',
            
            exports: {
                storeIds: '${ $.provider }:params.filters[${ $.column }]'
            },
            
            listens: {}
        },
        
        initialize: function () {
            this._super();
            
            _.bindAll(this, 'onChangeStore');
            
            return this;
        },
        
        initObservable: function () {
            this._super();
            
            this.storeIds = ko.observable();
            this.current = ko.observable(this.current);
            
            return this;
        },
        
        onChangeStore: function (store) {
            this.storeIds(store.storeIds);
            this.current(store.label);
        }
    });
});
