<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-report
 * @version   1.3.40
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Report\Api\Service;


use Mirasvit\Report\Api\Data\ReportInterface;

interface ColumnManagerInterface
{
    /**
     * Provide active columns for given $report
     *
     * @param ReportInterface $report
     *
     * @return string[]
     */
    public function getActiveColumns(ReportInterface $report);

    /**
     * @param string   $report  - report identifier
     * @param string[] $columns - active columns to save
     */
    public function setActiveColumns($report, array $columns = []);
}
