<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-report
 * @version   1.3.9
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\ReportApi\Service;


use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\ResourceConnection;
use Mirasvit\ReportApi\Api\Config\TableInterface;
use Mirasvit\ReportApi\Api\Service\TableServiceInterface;

class TableService implements TableServiceInterface
{
    /**
     * @var ResourceConnection
     */
    private $resource;

    public function __construct(
        ResourceConnection $resource
    ) {
        $this->resource = $resource;
    }

    /**
     * @return string[]
     */
    public function getTables()
    {
        $connection = $this->resource->getConnection();

        return $connection->getTables();
    }

    /**
     * {@inheritdoc}
     */
    public function getForeignKeys(TableInterface $table)
    {
        $connection = $this->resource->getConnection($table->getConnectionName());

        return $connection->getForeignKeys($this->getTableName($connection, $table));
    }

    /**
     * {@inheritdoc}
     */
    public function describeTable(TableInterface $table)
    {
        $connection = $this->resource->getConnection($table->getConnectionName());

        return $connection->describeTable($this->getTableName($connection, $table));
    }

    /**
     * Get table name.
     *
     * If table with a prefix does not exist, use without prefix one.
     *
     * @param \Magento\Framework\DB\Adapter\AdapterInterface $connection
     * @param TableInterface                                 $table
     *
     * @return string
     */
    private function getTableName(\Magento\Framework\DB\Adapter\AdapterInterface $connection, TableInterface $table)
    {
        $tableName = $this->resource->getTableName($table->getName());
        if (!$connection->isTableExists($tableName)) {
            $tableName = $table->getName();
        }

        return $tableName;
    }
}
