<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-report
 * @version   1.3.4
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Report\Ui\Component;

use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\AbstractComponent;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Mirasvit\Report\Ui\Context;
use Mirasvit\ReportApi\Api\SchemaInterface;

class Toolbar extends AbstractComponent
{
    /**
     * @var Context
     */
    private $uiContext;

    /**
     * @var SchemaInterface
     */
    private $provider;

    private $componentFactory;

    public function __construct(
        UiComponentFactory $componentFactory,
        SchemaInterface $provider,
        ContextInterface $context,
        Context $uiContext,
        array $components = [],
        array $data = []
    ) {
        $this->componentFactory = $componentFactory;
        $this->provider = $provider;
        $this->uiContext = $uiContext;

        parent::__construct($context, $components, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function getComponentName()
    {
        return 'toolbar';
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     */
    public function prepare()
    {
        $this->prepareOptions();

        $dimension = $this->uiContext->getActiveDimension();

        $this->getDataProvider()
            ->setDimension($dimension);

        parent::prepare();
    }

    /**
     * {@inheritdoc}
     */
    protected function prepareOptions()
    {
        $config = $this->getData('config');

        $config['fastFilters'] = [];
        foreach ($this->uiContext->getReport()->getFastFilters() as $columnName) {
            $type = $this->provider->getColumn($columnName)->getType()->getType();

            $component = $this->componentFactory->create("toolbar_filter_$type", null, [
                'column' => $columnName,
            ]);
            $component->prepare();

            $this->addComponent($columnName, $component);
        }

        $config['dimensions'] = [];
        foreach ($this->uiContext->getReport()->getDimensions() as $columnName) {
            $jsConfig = [];
            $jsConfig['column'] = $columnName;
            $jsConfig['label'] = $this->provider->getColumn($columnName)->getLabel();


            $config['dimensions'][] = $jsConfig;
        }

        $config['dimension'] = $this->uiContext->getActiveDimension();

        $this->setData('config', $config);
    }
    //
    //    /**
    //     * @param string $columnName
    //     * @return string
    //     */
    //    protected function getFilterValue($columnName)
    //    {
    //        $value = $this->getContext()->getFilterParam($columnName);
    //        if ($value) {
    //            $this->uiContext->getSession()->setData($columnName, $value);
    //        } else {
    //            $value = $this->uiContext->getSession()->getData($columnName);
    //        }
    //
    //        return $value;
    //    }
    //
    /**
     * @return \Mirasvit\Report\Ui\DataProvider
     */
    protected function getDataProvider()
    {
        return $this->getContext()->getDataProvider();
    }
}
