<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-report
 * @version   1.3.45
 * @copyright Copyright (C) 2018 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Report\Block\Adminhtml;

use Magento\Backend\Block\Template;
use Mirasvit\ReportApi\Api\SchemaInterface;

class SchemaJs extends Template
{
    protected $_template = 'Mirasvit_Report::schema_js.phtml';

    private   $schema;

    public function __construct(
        SchemaInterface $schema,
        Template\Context $context,
        array $data = []
    ) {
        $this->schema = $schema;

        parent::__construct($context, $data);
    }

    public function getConfig()
    {
        $result = [];

        foreach ($this->schema->getTables() as $table) {
            $result['tables'][] = [
                'identifier' => $table->getName(),
                'label'      => $table->getLabel() ? $table->getLabel() : $table->getName(),
                'internal'   => $table->getLabel() ? false : true,
            ];

            foreach ($table->getColumns() as $column) {
                $result['columns'][] = [
                    'label'      => $column->getLabel(),
                    'identifier' => $column->getIdentifier(),
                    'table'      => $column->getTable()->getName(),
                    'type'       => [
                        'type'         => $column->getType()->getType(),
                        'jsFilterType' => $column->getType()->getJsFilterType(),
                        'jsType'       => $column->getType()->getJsType(),
                        'valueType'    => $column->getType()->getValueType(),
                    ],
                    'aggregator' => [
                        'type'  => $column->getAggregator()->getType(),
                        'label' => $column->getAggregator()->getLabel(),
                    ],
                    'options'    => method_exists($column->getType(), 'getOptions')
                        ? $column->getType()->getOptions()
                        : [],
                ];
            }
        }

        return $result;
    }
}