<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-message-queue
 * @version   1.0.0
 * @copyright Copyright (C) 2017 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Mq\Provider\Amqp;

use Magento\Framework\App\DeploymentConfig;
use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Channel\AMQPChannel;
use PhpAmqpLib\Message\AMQPMessage;

class Client
{
    /**
     * @var AMQPChannel
     */
    private $channel;

    /**
     * @var DeploymentConfig
     */
    private $deploymentConfig;

    public function __construct(
        DeploymentConfig $deploymentConfig
    ) {
        $this->deploymentConfig = $deploymentConfig;
    }

    /**
     * @return AMQPChannel
     */
    public function getChannel()
    {
        if (!$this->channel && $this->deploymentConfig->get('queue/amqp/host')) {
            $connection = new AMQPStreamConnection(
                $this->deploymentConfig->get('queue/amqp/host'),
                $this->deploymentConfig->get('queue/amqp/port'),
                $this->deploymentConfig->get('queue/amqp/username'),
                $this->deploymentConfig->get('queue/amqp/password'),
                $this->deploymentConfig->get('queue/amqp/virtual_host')
            );

            $this->channel = $connection->channel();
        }

        return $this->channel;
    }
}