<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-event
 * @version   1.4.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Event\Cron;

use Mirasvit\Event\Api\Data\EventInterface;
use Mirasvit\Event\Api\Repository\EventRepositoryInterface;

class RemoveOldEventCron
{
    private $eventRepository;

    public function __construct(EventRepositoryInterface $eventRepository)
    {
        $this->eventRepository = $eventRepository;
    }

    public function execute()
    {
        $date       = date('Y-m-d H:i:s', time() - 30 * 24 * 60 * 60);
        $collection = $this->eventRepository->getCollection()->addFieldToFilter(EventInterface::CREATED_AT, ['lt' => $date]);
        foreach ($collection as $event) {
            $this->eventRepository->delete($event);
        }
    }
}
