### Example of Subscribe (di.xml):
```
<type name="Mirasvit\Event\Repository\SubscriberRepository">
    <arguments>
        <argument name="subscribers" xsi:type="array">
            <item name="follow_up_email" xsi:type="array">
                <item name="type" xsi:type="string">Mirasvit\Email\Service\EventProcessor</item>
                <item name="method" xsi:type="string">execute</item>
            </item>
        </argument>
    </arguments>
</type>
```


### Change message queue from MySQL to AMQP (app/etc/env.php):

```
'queue' => [

        ...

        'topics' => [
            'mirasvit.event.mq.register' => [
                'publisher' => 'amqp-magento'
            ]
        ],
        'config' => [
            'publishers' => [
                'mirasvit.event.mq.register' => [
                    'connections' => [
                        'amqp' => [
                            'name' => 'amqp',
                            'exchange' => 'magento',
                            'disabled' => false
                        ],
                        'db' => [
                            'name' => 'db',
                            'disabled' => true
                        ]
                    ]
                ]
            ]
        ],
        'consumers' => [
            'mirasvit.event.mq.register' => [
                'connection' => 'amqp'
            ]
        ],
        
        ...

    ],
```
