<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-event
 * @version   1.4.5
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Event\Service;


use Magento\Framework\App\ObjectManager;
use Mirasvit\Event\Repository\SubscriberRepository;

class EventProcessor
{
    private $objectManager;

    private $repository;

    public function __construct(SubscriberRepository $repository, ObjectManager $objectManager = null)
    {
        $this->repository    = $repository;
        $this->objectManager = $objectManager;
    }

    public function processEvent(int $eventId): void
    {
        if (!$this->objectManager) {
            $this->objectManager = ObjectManager::getInstance();
        }

        foreach ($this->repository->getSubscribers() as $subscriber) {
            $subscriberInstance = $this->objectManager->get($subscriber['type']);

            if ($subscriberInstance && method_exists($subscriberInstance, $subscriber['method'])) {
                $subscriberInstance->{$subscriber['method']}((int)$eventId);
            }
        }
    }
}
