<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-event
 * @version   1.2.35
 * @copyright Copyright (C) 2020 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Event\Api\Data\Event;


use Magento\Framework\DataObject;

interface ObservableEventWrapperInterface
{
    /**
     * Gives a class name of the observed model.
     *
     * @return string
     */
    public function getObservedClassName();

    /**
     * Register an object save event.
     *
     * @param DataObject $object
     *
     * @return bool - true on success, false otherwise
     */
    public function register(DataObject $object);
}
