<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.4
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Setup\Patch\Data;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Email\Repository\CampaignRepository;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\Email\Repository\TriggerRepository;
use Mirasvit\Email\Helper\Data;
use Mirasvit\Email\Helper\Serializer;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection as ChainCollection;
use Mirasvit\Email\Model\Trigger\Chain;
use Mirasvit\EmailDesigner\Model\Template;


class DataPatch113 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;

    private $chainRepository;

    public function __construct(
        ModuleDataSetupInterface $setup,
        ChainRepository $chainRepository
    ) {
        $this->setup           = $setup;
        $this->chainRepository = $chainRepository;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->setup->getConnection()->startSetup();
        $this->reformatTemplateIds();
        $this->setup->getConnection()->endSetup();
    }

    /**
     * We added ability to use native Magento templates for triggers.
     * So we should update all triggers' chains for new format of template_id identifier.
     */
    private function reformatTemplateIds()
    {
        foreach ($this->chainRepository->getCollection() as $chain) {
            if (strpos($chain->getTemplateId(), Template::TYPE) === false) {
                $chain->setTemplateId(Template::TYPE . ':' . $chain->getTemplateId());
                $this->chainRepository->save($chain);
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.13';
    }


    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [DataPatch110::class];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
