<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Block\Adminhtml;

use Magento\Framework\DataObject;
use Magento\Backend\Block\Template\Context;
use Mirasvit\Core\Block\Adminhtml\AbstractMenu;
use Mirasvit\EmailReport\Controller\Adminhtml\Report\Index as ReportIndexController;

class Menu extends AbstractMenu
{
    public function __construct(
        Context $context
    ) {
        $this->visibleAt(['email']);

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    protected function buildMenu()
    {
        $this->addItem([
            'id'       => 'emailreport',
            'resource' => ReportIndexController::ADMIN_RESOURCE,
            'title'    =>(string)__('Reports'),
            'url'      => $this->urlBuilder->getUrl('emailreport/report'),
        ], 'email');

        return $this;
    }
}
