<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Ui\Chain\Form;

use Magento\Ui\DataProvider\AbstractDataProvider;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Mirasvit\Email\Api\Data\ChainInterface;
use Mirasvit\Email\Repository\Trigger\ChainRepository;

class DataProvider extends AbstractDataProvider
{
    private $chainRepository;

    /**
     * @var array
     */
    protected $loadedData;

    private $context;

    public function __construct(
        ContextInterface $context,
        ChainRepository $chainRepository,
        string $name,
        string $primaryFieldName,
        string $requestFieldName,
        array $meta = [],
        array $data = []
    ) {
        $this->context = $context;
        $this->chainRepository = $chainRepository;
        $this->collection = $this->chainRepository->getCollection();

        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function getMeta()
    {
        return parent::getMeta();
    }

    /**
     * {@inheritdoc}
     */
    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }

        /** @var ChainInterface $item */
        foreach ($this->collection as $item) {
            $item = $this->chainRepository->get($item->getId());
            $data = $item->getData();

            $data['id_field_name'] = $this->getRequestFieldName();
            $this->loadedData[$item->getId()] = $data;

            if ($this->context->getRequestParam($this->getRequestFieldName()) === $item->getId()
                && isset($data['report'])
            ) {
                $this->loadedData['report'] = $data['report'];
            }
        }

        return $this->loadedData;
    }
}
