<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Repository\Trigger;

use Mirasvit\Email\Api\Data\QueueInterface;
use Mirasvit\Email\Repository\QueueRepository;
use Magento\Framework\EntityManager\EntityManager;
use Magento\Framework\Exception\NoSuchEntityException;
use Mirasvit\Email\Api\Data\ChainInterface;
use Mirasvit\Email\Api\Data\ChainInterfaceFactory;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\CollectionFactory;

class ChainRepository
{
    /**
     * @var ChainInterface[]
     */
    private $chainRegistry = [];

    private $entityManager;

    private $chainFactory;

    private $collectionFactory;

    private $queueRepository;

    public function __construct(
        QueueRepository $queueRepository,
        EntityManager $entityManager,
        ChainInterfaceFactory $chainFactory,
        CollectionFactory $collectionFactory
    ) {
        $this->queueRepository   = $queueRepository;
        $this->entityManager     = $entityManager;
        $this->chainFactory      = $chainFactory;
        $this->collectionFactory = $collectionFactory;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function create(): ChainInterface
    {
        return $this->chainFactory->create();
    }

    public function get(int $id = null): ChainInterface
    {
        if ($id && isset($this->chainRegistry[$id])) {
            return $this->chainRegistry[$id];
        }

        $chain = $this->create();
        $chain = $this->entityManager->load($chain, $id);

        if ($chain->getId()) {
            $this->chainRegistry[$id] = $chain;
        }

        return $chain;
    }

    public function save(ChainInterface $model): ChainInterface
    {
        $model->setExcludeDays($model->getExcludeDays());

        return $this->entityManager->save($model);
    }

    public function delete(ChainInterface $model): bool
    {
        $queueToDelete = $this->queueRepository->getCollection();
        $queueToDelete->addFieldToFilter(QueueInterface::STATUS, QueueInterface::STATUS_PENDING)
            ->addFieldToFilter(ChainInterface::ID, $model->getId());

        foreach ($queueToDelete as $queue) {
            $queue->cancel((string)__('Associated email chain was removed from a trigger.'));
        }

        return $this->entityManager->delete($model);
    }
}
