<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Adminhtml\Campaign;

use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\Email\Repository\CampaignTemplateRepository;
use Mirasvit\Email\Controller\Adminhtml\Campaign;

class Save extends Campaign
{
    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        $back = $this->getRequest()->getParam('back');

        if ($data = $this->getRequest()->getParams()) {
            $model = $this->initModel();

            try {
                $model = $this->save($model, $data);

                if ($this->getRequest()->getParam(CampaignInterface::ID)) {
                    $this->messageManager->addSuccessMessage((string)__('Campaign was successfully saved'));
                }

                if ($back === 'edit') {
                    return $resultRedirect->setPath('*/*/view', [CampaignInterface::ID => $model->getId()]);
                }

                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                return $resultRedirect->setPath('*/*/view', [CampaignInterface::ID => $model->getId()]);
            }
        }

        $this->messageManager->addErrorMessage((string)__('Unable to find campaign to save'));

        return $resultRedirect->setPath('*/*/');
    }

    /**
     * @param CampaignInterface $model
     * @param array $data
     * @return \Magento\Framework\Model\AbstractModel|CampaignInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    private function save(CampaignInterface $model, array $data)
    {
        if ($this->getRequest()->getParam('template_id')) {
            /** @var CampaignTemplateRepository $templateRepository */
            $templateRepository = $this->_objectManager->get(CampaignTemplateRepository::class);
            $model = $templateRepository->create((string)$this->getRequest()->getParam('template_id'));
        } else {
            $model->addData($data);
            $this->campaignRepository->save($model);
        }

        return $model;
    }
}
