<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.6
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Controller\Action;

use Magento\Framework\Controller\ResultFactory;
use Mirasvit\Email\Controller\Action;
use Mirasvit\Email\Model\Unsubscription;

class Unsubscribe extends Action
{
    private $unsubscription;

    protected $resultFactory;

    public function __construct(
        ResultFactory  $resultFactory,
        Unsubscription $unsubscription,
        Context        $context
    ) {
        parent::__construct($context);

        $this->resultFactory  = $resultFactory;
        $this->unsubscription = $unsubscription;
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $redirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $redirect->setPath('/');

        if ($hash = $this->getRequest()->getParam('hash')) {
            $queue = $this->frontendHelper->getQueue($hash);

            if (!$queue) {
                $this->messageManager->addErrorMessage((string)__('Wrong unsubscription link'));

                return $redirect;
            }

            $this->unsubscription->unsubscribe($queue->getRecipientEmail(), $queue->getTriggerId());

            $this->messageManager
                ->addSuccessMessage(__('Email %1 has been successfully unsubscribed from receiving emails', $queue->getRecipientEmail()));
        }

        return $redirect;
    }
}
