<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.3.2
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;

class ConfigProvider
{
    protected $scopeConfig;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Test email
     */
    public function getTestEmail(): string
    {
        $email = (string)$this->scopeConfig->getValue('email/test/email');
        if (!$email) {
            $email = (string)$this->scopeConfig->getValue('trans_email/ident_general/email');
        }

        return $email;
    }

    public function isSandbox(): bool
    {
        return (bool)$this->scopeConfig->getValue('email/test/sandbox');
    }

    public function getSandboxEmail(): string
    {
        return (string)$this->scopeConfig->getValue('email/test/email');
    }

    public function getEmailLimit(): int
    {
        return (int)$this->scopeConfig->getValue('email/general/max_email');
    }

    public function getEmailLimitPeriod(): int
    {
        return (int)$this->scopeConfig->getValue('email/general/max_email_period');
    }

    public function getCouponLength(): int
    {
        return (int)$this->scopeConfig->getValue('email/coupon/length');
    }

    public function getCouponPrefix(): string
    {
        return (string)$this->scopeConfig->getValue('email/coupon/prefix');
    }

    public function getCouponSuffix(): string
    {
        return (string)$this->scopeConfig->getValue('email/coupon/suffix');
    }

    public function getCouponDash(): int
    {
        return (int)$this->scopeConfig->getValue('email/coupon/dash');
    }

    public function getFacebookUrl(): string
    {
        return (string)$this->scopeConfig->getValue('email/info/facebook_url');
    }

    public function getTwitterUrl(): string
    {
        return (string)$this->scopeConfig->getValue('email/info/twitter_url');
    }
}
