<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.2
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Controller\Adminhtml\Theme;

use Magento\Framework\Registry;
use Magento\Backend\App\Action\Context;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterface;
use Mirasvit\EmailDesigner\Controller\Adminhtml\Theme;
use Mirasvit\EmailDesigner\Repository\ThemeRepository;
use Mirasvit\EmailDesigner\Repository\TemplateRepository;

class Delete extends Theme
{
    public function __construct(
        TemplateRepository $templateRepository,
        ThemeRepository    $themeRepository,
        Registry           $registry,
        Context            $context
    ) {
        $this->templateRepository = $templateRepository;

        parent::__construct($themeRepository, $registry, $context);
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();

        try {
            $theme = $this->initModel();
            if ($theme->getId() == 1) {
                $this->messageManager->addErrorMessage((string)__('Sorry, but you cannot remove the default theme.'));
                return $resultRedirect->setPath('*/*/', [
                    ThemeInterface::ID => $this->getRequest()->getParam(ThemeInterface::ID)
                ]);
            } elseif ($this->isUsed($theme->getId()) === true) {
                $this->messageManager->addErrorMessage((string)__('Sorry, but you cannot delete theme used in the template.'));
                return $resultRedirect->setPath('*/*/', [

                    ThemeInterface::ID => $this->getRequest()->getParam(ThemeInterface::ID)
                ]);
            }
            $this->themeRepository->delete($theme);
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());

            return $resultRedirect->setPath('*/*/edit', [
                ThemeInterface::ID => $this->getRequest()->getParam(ThemeInterface::ID)
            ]);
        }

        $this->messageManager->addSuccessMessage((string)__('Theme was successfully deleted'));
        return $resultRedirect->setPath('*/*/');
    }

    public function isUsed($themeId)
    {
        $templateCollection = $this->templateRepository->getCollection();
        foreach ($templateCollection as $template) {
            if ($template->getThemeId() == $themeId) {
              return true;
            }
        }

        return false;
    }
}
