<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.2
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Email\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Mirasvit\Event\Api\Repository\EventRepositoryInterface;

class EventSource implements OptionSourceInterface
{
    private $eventRepository;

    public function __construct(
        EventRepositoryInterface $eventRepository
    ) {
        $this->eventRepository = $eventRepository;
    }

    public function toOptionArray(): array
    {
        $result = [];

        foreach ($this->eventRepository->getEvents() as $instance) {
            foreach ($instance->getEvents() as $identifier => $label) {

                $result[] = [
                    'label' => (string)$label,
                    'value' => $identifier,
                ];
            }
        }

        return $result;
    }
}
