<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.2
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Controller\Action;

use Mirasvit\Email\Repository\QueueRepository;
use Mirasvit\Email\Controller\Action;
use Mirasvit\Email\Service\FrontSessionInitiator;

class SendAll extends Action
{
    private $queueRepository;
    private $emailSessionManager;


    public function __construct(
        FrontSessionInitiator $emailSessionManager,
        QueueRepository $queueRepository,
        Context $context
    ) {
        parent::__construct($context);

        $this->emailSessionManager = $emailSessionManager;
        $this->queueRepository = $queueRepository;
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($this->getRequest()->getParam('form_key', null) !== $this->emailSessionManager->get()) {
            /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
            $this->messageManager->addErrorMessage((string)__('Operation is not allowed.'));

            return $resultRedirect->setPath('/');
        }

        $sent = 0;
        foreach (explode(',', $this->getRequest()->getParam('queue')) as $id) {
            $queue = $this->queueRepository->get((int)$id);
            if ($queue) {
                $queue->send(true);
                $sent++;
            }
        }

        $this->messageManager->addSuccessMessage(
           (string)__('A total of %1 record(s) have been sent.', $sent)
        );

        return $resultRedirect->setUrl($this->_redirect->getRefererUrl());
    }
}
