<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.2
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Block\Adminhtml\Unsubscription;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Grid\Extended as GridExtended;
use Magento\Backend\Helper\Data as BackendHelper;
use Mirasvit\Email\Api\Data\QueueInterface;
use Mirasvit\Email\Model\Queue;
use Mirasvit\Email\Model\Config\Source\TriggerSource;
use Mirasvit\Email\Model\ResourceModel\Queue\CollectionFactory as QueueCollectionFactory;
use Mirasvit\Email\Model\ResourceModel\Trigger\CollectionFactory as TriggerCollectionFactory;
use Mirasvit\Email\Model\ResourceModel\Unsubscription\CollectionFactory as UnsubscriptionCollectionFactory;
use Magento\Newsletter\Model\SubscriberFactory;

class Grid extends GridExtended
{
    protected $subscriberFactory;

    protected $queueCollectionFactory;

    protected $triggerCollectionFactory;

    protected $unsubscriptionCollectionFactory;

    protected $triggers;

    private   $frontUrlBuilder;


    public function __construct(
        SubscriberFactory               $subscriberFactory,
        \Magento\Framework\Url          $frontUrlBuilder,
        QueueCollectionFactory          $queueQueueCollectionFactory,
        TriggerCollectionFactory        $triggerCollectionFactory,
        TriggerSource                   $triggers,
        UnsubscriptionCollectionFactory $unsubscriptionCollectionFactory,
        Context                         $context,
        BackendHelper                   $backendHelper
    ) {
        $this->subscriberFactory               = $subscriberFactory;
        $this->frontUrlBuilder                 = $frontUrlBuilder;
        $this->queueCollectionFactory          = $queueQueueCollectionFactory;
        $this->triggerCollectionFactory        = $triggerCollectionFactory;
        $this->triggers                        = $triggers;
        $this->unsubscriptionCollectionFactory = $unsubscriptionCollectionFactory;

        parent::__construct($context, $backendHelper);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('email_unsubscription_grid');
        $this->setDefaultSort('unsubscription_id');
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
    }

    /**
     * {@inheritdoc}
     */
    protected function _prepareCollection()
    {
        $collection = $this->unsubscriptionCollectionFactory->create();

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    protected function _prepareColumns()
    {
        $this->addColumn('unsubscription_id', [
            'header' => (string)__('ID'),
            'type'   => 'number',
            'index'  => 'unsubscription_id',
        ]);

        $triggers = [];
        foreach ($this->triggers->toOptionArray() as $itm) {
            $triggers[$itm['value']] = $itm['label'];
        }

        $this->addColumn('trigger_id', [
            'header'  => (string)__('Trigger'),
            'index'   => 'trigger_id',
            'type'    => 'options',
            'options' => $triggers,
        ]);

        $this->addColumn('updated_at', [
            'header' => (string)__('Updated At'),
            'type'   => 'datetime',
            'index'  => 'updated_at',
        ]);

        $this->addColumn('email', [
            'header' => (string)__('Email'),
            'index'  => 'email',
        ]);

        $this->addColumn('action', [
            'header'    => (string)__('Action'),
            'type'      => 'action',
            'getter'    => 'getId',
            'actions'   => [
                [
                    'caption' => (string)__('Subscribe'),
                    'url'     => ['base' => '*/*/subscribe'],
                    'field'   => 'id',
                    'confirm' => (string)__('Are you sure?'),
                ],
            ],
            'filter'    => false,
            'sortable'  => false,
            'is_system' => true,
        ]);

        return parent::_prepareColumns();
    }

    /**
     * {@inheritdoc}
     */
    protected function _prepareMassaction()
    {
        $this->setMassactionIdField('unsubscription_id');
        $this->getMassactionBlock()->setFormFieldName('unsubscription_id');

        $this->getMassactionBlock()->addItem('mass_subscription', [
            'label'   => (string)__('Subscribe'),
            'url'     => $this->getUrl('*/*/massSubscribe'),
            'confirm' => (string)__('Are you sure?'),
        ]);

        return $this;
    }
}
