<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Model;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;

class ConfigProvider
{
    protected $filesystem;

    public function __construct(
        Filesystem $filesystem
    ) {
        $this->filesystem = $filesystem;
    }

    public function getBasePath(): string
    {
        $dir = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . 'email_designer';
        if (!file_exists($dir)) {
            mkdir($dir);
        }

        return $dir;
    }

    public function getTmpPath(): string
    {
        $dir = $this->getBasePath() . '/tmp';
        if (!file_exists($dir)) {
            mkdir($dir);
        }

        return $dir;
    }

    public function getThemePath(): string
    {
        $dir = $this->getBasePath() . '/theme';
        if (!file_exists($dir)) {
            mkdir($dir);
        }

        return $dir;
    }

    public function getTemplatePath(): string
    {
        $dir = $this->getBasePath() . '/template';
        if (!file_exists($dir)) {
            mkdir($dir);
        }

        return $dir;
    }
}
