<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.3
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Ui;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Ui\Component\AbstractComponent;
use Mirasvit\Email\Api\Data\CampaignInterface;
use Mirasvit\EmailReport\Api\Data\ClickInterface;
use Mirasvit\EmailReport\Api\Data\EmailInterface;
use Mirasvit\EmailReport\Api\Data\OpenInterface;
use Mirasvit\EmailReport\Api\Data\OrderInterface;
use Mirasvit\EmailReport\Api\Data\ReviewInterface;
use Mirasvit\EmailReport\Repository\ClickRepository;
use Mirasvit\EmailReport\Repository\EmailRepository;
use Mirasvit\EmailReport\Repository\OpenRepository;
use Mirasvit\EmailReport\Repository\OrderRepository;
use Mirasvit\EmailReport\Repository\ReviewRepository;

class Overview extends AbstractComponent
{
    private $reportDataProvider;

    public function __construct(
        ReportDataProvider $reportDataProvider,
        ContextInterface $context,
        $components = [],
        array $data = []
    ) {
        $this->reportDataProvider = $reportDataProvider;

        parent::__construct($context, $components, $data);
    }

    /**
     * @return string
     */
    public function getComponentName()
    {
        return 'email_report_overview';
    }

    public function prepare()
    {
        $config = $this->getData('config');

        $data = [];

        if ($this->context->getRequestParam(CampaignInterface::ID)) {
            $data['id_field_name'] = CampaignInterface::ID;
            $data[CampaignInterface::ID] = $this->context->getRequestParam(CampaignInterface::ID);
        }

        $data = $this->reportDataProvider->addReportData($data);

        $config = array_merge_recursive($config, $data);

        $this->setData('config', $config);

        parent::prepare();
    }
}
