<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.3
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailReport\Service;

use Mirasvit\Email\Api\Data\QueueInterface;
use Mirasvit\Email\Repository\QueueRepository;
use Mirasvit\EmailReport\Service\Cookie;

class StorageService
{
    const QUEUE_PARAM_NAME = 'qid';

    private $cookie;

    private $queueRepository;


    public function __construct(
        Cookie $cookie,
        QueueRepository $queueRepository
    ) {
        $this->cookie          = $cookie;
        $this->queueRepository = $queueRepository;
    }

    public function persistQueueHash(string $hash): void
    {
        $this->cookie->set(self::QUEUE_PARAM_NAME, $hash, 3600 * 3);
    }

    public function retrieveQueueHash(): ?string
    {
        return $this->cookie->get(self::QUEUE_PARAM_NAME);
    }

    public function retrieveQueue(string $hash = null): ?QueueInterface
    {
        if (!$hash) {
            $hash = $this->retrieveQueueHash();
        }

        if (!$hash) {
            return null;
        }

        $queue = $this->queueRepository->getByUniqueHash($hash);

        if ($queue && $queue->getTrigger() && $queue->getTrigger()->getId()) {
            return $queue;
        }

        return null;
    }
}
