<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.3
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Repository;


use Magento\Framework\EntityManager\EntityManager;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterface;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterfaceFactory;
use Mirasvit\EmailDesigner\Model\ResourceModel\Theme\Collection;
use Mirasvit\EmailDesigner\Model\ResourceModel\Theme\CollectionFactory;

class ThemeRepository
{
    /**
     * @var ThemeInterface[]
     */
    private $themeRegistry = [];

    private $entityManager;

    private $modelFactory;

    private $collectionFactory;

    public function __construct(
        EntityManager $entityManager,
        ThemeInterfaceFactory $modelFactory,
        CollectionFactory $collectionFactory
    ) {
        $this->entityManager     = $entityManager;
        $this->modelFactory      = $modelFactory;
        $this->collectionFactory = $collectionFactory;
    }

    public function getCollection(): Collection
    {
        return $this->collectionFactory->create();
    }

    public function create(): ThemeInterface
    {
        return $this->modelFactory->create();
    }

    public function get(int $id): ?ThemeInterface
    {
        if (isset($this->themeRegistry[$id])) {
            return $this->themeRegistry[$id];
        }

        $theme = $this->create();
        $theme = $this->entityManager->load($theme, $id);

        if ($theme->getId()) {
            $this->themeRegistry[$id] = $theme;
        } else {
            return null;
        }

        return $theme;
    }

    public function save(ThemeInterface $theme): ThemeInterface
    {
        return $this->entityManager->save($theme);
    }

    public function delete(ThemeInterface $theme): bool
    {
        return $this->entityManager->delete($theme);
    }
}
