<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.3
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\EmailDesigner\Block\Adminhtml\Theme;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Grid\Extended as ExtendedGrid;
use Magento\Backend\Helper\Data as BackendHelper;
use Mirasvit\EmailDesigner\Api\Data\ThemeInterface;
use Mirasvit\EmailDesigner\Model\ResourceModel\Theme\CollectionFactory as ThemeCollectionFactory;

class Grid extends ExtendedGrid
{
    protected $themeCollectionFactory;


    public function __construct(
        ThemeCollectionFactory $themeCollectionFactory,
        Context                $context,
        BackendHelper          $backendHelper
    ) {
        $this->themeCollectionFactory = $themeCollectionFactory;

        parent::__construct($context, $backendHelper);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setId('email_designer_theme_grid');
        $this->setDefaultSort(ThemeInterface::ID);
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
    }

    /**
     * {@inheritdoc}
     */
    protected function _prepareCollection()
    {
        $collection = $this->themeCollectionFactory->create();

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    /**
     * {@inheritdoc}
     */
    protected function _prepareColumns()
    {
        $this->addColumn(ThemeInterface::ID, [
            'header' => (string)__('ID'),
            'index'  => ThemeInterface::ID,
        ]);

        $this->addColumn('title', [
            'header' => (string)__('Title'),
            'index'  => 'title',
        ]);

        $this->addColumn('action', [
            'header'    => (string)__('Actions'),
            'type'      => 'action',
            'getter'    => 'getId',
            'actions'   => [
                [
                    'caption' => (string)__('Edit'),
                    'url'     => ['base' => '*/*/edit'],
                    'field'   => ThemeInterface::ID,
                ],
//              [
//                    'caption' => (string)__('Export'),
//                    'url'     => ['base' => '*/*/export'],
//                    'field'   => ThemeInterface::ID,
//              ],
                [
                    'caption' => (string)__('Remove'),
                    'url'     => ['base' => '*/*/delete'],
                    'field'   => ThemeInterface::ID,
                ],
                [
                    'caption' => (string)__('Duplicate'),
                    'url'     => ['base' => '*/*/duplicate'],
                    'field'   => ThemeInterface::ID,
                ],
            ],
            'filter'    => false,
            'sortable'  => false,
            'is_system' => true,
        ]);

        return parent::_prepareColumns();
    }

    /**
     * {@inheritdoc}
     */
    public function getRowUrl($row)
    {
        return $this->getUrl('*/*/edit', [ThemeInterface::ID => $row->getId()]);
    }
}
