<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.4.3
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Setup\Patch\Data;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection as ChainCollection;
use Mirasvit\Email\Model\Trigger\Chain;


class DataPatch102 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;
    private $chainRepository;

    public function __construct(
        ModuleDataSetupInterface $setup,
        ChainRepository $chainRepository
    ) {
        $this->setup = $setup;
        $this->chainRepository = $chainRepository;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->setup->getConnection()->startSetup();
        $installer = $this->setup;

        /** @var ChainCollection $chainCollection */
        $chainCollection = $this->chainRepository->getCollection()->loadData();
        /** @var Chain $chain */
        foreach ($chainCollection as $chain) {
            if (!$chain->getFrequencyType()) {
                $chain->setFrequencyType('at')
                    ->setScheduleType($chain->getType())
                    ->setRange('day')
                    ->setFrequency($chain->getData('days') / 24 / 60 / 60)
                    ->setHours($chain->getData('hours') / 60 / 60)
                    ->setMinutes($chain->getData('minutes') / 60)
                    ->save();
            }
        }
        $this->setup->getConnection()->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.2';
    }


    /**
     * {@inheritdoc}
     */
    public static function getDependencies() {
        return [DataPatch100::class];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases() {
        return [];
    }
}
