<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.5
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Setup\Patch\Data;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\Email\Repository\CampaignRepository;
use Mirasvit\Email\Repository\Trigger\ChainRepository;
use Mirasvit\Email\Repository\TriggerRepository;
use Mirasvit\Email\Helper\Data;
use Mirasvit\Email\Helper\Serializer;
use Mirasvit\Email\Model\ResourceModel\Trigger\Chain\Collection as ChainCollection;
use Mirasvit\Email\Model\Trigger\Chain;


class DataPatch110 implements DataPatchInterface, PatchVersionInterface
{
    private $setup;
    private $triggerRepository;
    private $campaignRepository;

    public function __construct(
        ModuleDataSetupInterface $setup,
        TriggerRepository $triggerRepository,
        CampaignRepository $campaignRepository
    ) {
        $this->setup = $setup;
        $this->triggerRepository = $triggerRepository;
        $this->campaignRepository = $campaignRepository;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->setup->getConnection()->startSetup();
        $setup = $this->setup;

        $this->createCampaigns();

        $this->setup->getConnection()->endSetup();
    }

    /**
     * Create campaigns based on existing triggers.
     */
    private function createCampaigns()
    {
        foreach ($this->triggerRepository->getCollection() as $trigger) {
            // create campaign
            $campaign = $this->campaignRepository->create();
            $campaign->setTitle('Campaign: ' . $trigger->getTitle())
                ->setDescription($trigger->getDescription())
                ->setIsActive($trigger->getIsActive());
            $this->campaignRepository->save($campaign);

            // connect with trigger
            $trigger->setCampaignId($campaign->getId());
            $this->triggerRepository->save($trigger);
        }
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion(): string
    {
        return '1.0.10';
    }


    /**
     * {@inheritdoc}
     */
    public static function getDependencies() {
        return [DataPatch106::class];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases() {
        return [];
    }
}
