<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.5
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\Email\Service;

use Magento\Framework\Model\AbstractModel;

class CloneService
{
    /**
     * @param AbstractModel $model
     * @param object $repository
     * @param array $unsetData
     * @param array $data
     *
     * @return AbstractModel
     */
    public function duplicate(AbstractModel $model, $repository, array $unsetData = [], array $data = []): AbstractModel
    {
        $modelClone = clone $model;
        $modelClone->unsetData($unsetData)
            ->addData($data);

        $repository->save($modelClone);

        return $modelClone;
    }
}
