<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-email
 * @version   2.5.5
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\Email\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Mirasvit\Email\Repository\TriggerRepository;

class TriggerSource implements OptionSourceInterface
{
    protected $triggerRepository;

    public function __construct(
        TriggerRepository $triggerRepository
    ) {
        $this->triggerRepository = $triggerRepository;
    }

    public function toOptionArray(): array
    {
        $collection = $this->triggerRepository->getCollection();
        $result = [];

        foreach ($collection as $trigger) {
            $result[] = [
                'label' => $trigger->getTitle(),
                'value' => $trigger->getId(),
            ];
        }

        return $result;
    }
}
